

# This file was *autogenerated* from the file approximant.sage
from sage.all_cmdline import *   # import sage library

_sage_const_0 = Integer(0); _sage_const_1 = Integer(1); _sage_const_2 = Integer(2); _sage_const_100 = Integer(100); _sage_const_3 = Integer(3)# approximant() copied from https://eprint.iacr.org/2022/473 Algorithm 4.4
# see Theorem 4.1 for proof

# uses basic matrices and polys, not Sage's berlekamp_massey()

def approximant(t,k,A,B):
  r'''
  Return a,b in the polynomial ring k[x]
  with gcd{a,b} = 1,
  deg a <= t,
  deg b < t,
  and deg(aB-bA) < deg A - t.

  INPUT:

  "t" - a nonnegative integer

  "k" - a field
  
  "A" - an element of k[x]

  "B" - an element of k[x] with deg A > deg B
  '''

  assert t >= _sage_const_0  and A.base_ring() == k and B.base_ring() == k
  kpoly,n = A.parent(),A.degree()
  assert n > B.degree()
  M = [   [ B[t+n-_sage_const_1 -i-j] for i in range(t+_sage_const_1 )]
        + [-A[t+n-_sage_const_1 -i-j] for i in range(t)  ] for j in range(_sage_const_2 *t)]
  M = matrix(k,_sage_const_2 *t,_sage_const_2 *t+_sage_const_1 ,M)
  ab = list(M.right_kernel().gens()[_sage_const_0 ])
  a,b = kpoly(ab[:t+_sage_const_1 ]),kpoly(ab[t+_sage_const_1 :])
  d = gcd(a,b)
  return a//d,b//d

# ---- miscellaneous tests
# copied from https://eprint.iacr.org/2022/473 Figure A.2

def test_smallrandom():
  for q in range(_sage_const_100 ):
    q = ZZ(q)
    if not q.is_prime_power(): continue
    print('approximant %d' % q)
    sys.stdout.flush()
    k = GF(q)
    kpoly = k['x']; (x,) = kpoly._first_ngens(1)
    for loop in range(_sage_const_100 ):
      Adeg = randrange(_sage_const_100 )
      A = kpoly([k.random_element() for j in range(Adeg)]+[_sage_const_1 ])
      if Adeg == _sage_const_0 :
        B = kpoly(_sage_const_0 )
      else:
        Bdeg = randrange(Adeg)
        B = kpoly([k.random_element() for j in range(Bdeg+_sage_const_1 )])
        # note that B could actually have lower degree
      t = randrange(Adeg+_sage_const_3 )
      a,b = approximant(t,k,A,B)
      assert gcd(a,b) == _sage_const_1 
      assert a.degree() <= t
      assert b.degree() < t
      assert a != _sage_const_0 
      assert a*B-b*A == _sage_const_0  or (a*B-b*A).degree() < A.degree()-t

if __name__ == '__main__':
  test_smallrandom()

