

# This file was *autogenerated* from the file test-padding.sage
from sage.all_cmdline import *   # import sage library

_sage_const_1 = Integer(1); _sage_const_8 = Integer(8); _sage_const_100 = Integer(100); _sage_const_10 = Integer(10)
import parameters
import keygen
import encap
import decap

def randombytes(r):
  return os.urandom(r)

systems = parameters.alltests
if len(sys.argv) > _sage_const_1 :
  systems = sys.argv[_sage_const_1 :]

for system in systems:
  print(system)
  sys.stdout.flush()

  params = parameters.parameters(system,allowtestparams=True)

  pk,sk = keygen.keygen(randombytes,params)
  C,sessionkey = encap.encap(pk,randombytes,params)
  assert decap.decap(C,sk,params) == sessionkey

  k = params.k
  mt = params.m*params.t

  if k < _sage_const_8 *ceil(k/_sage_const_8 ):
    for row in range(mt):
      rowpos = row*_sage_const_8 *ceil(k/_sage_const_8 )
      for j in range(rowpos+k,rowpos+_sage_const_8 *ceil(k/_sage_const_8 )):
        print('pk padding bit',j)
        sys.stdout.flush()
        pk2 = bytearray(pk)
        pk2[j//_sage_const_8 ] |= _sage_const_1 <<(j%_sage_const_8 )
        pk2 = bytes(pk2)
        assert pk2 != pk
        assert encap.encap(pk2,randombytes,params) == False

  for loop in range(_sage_const_100 ):
    row = randrange(mt)
    rowpos = row*_sage_const_8 *ceil(k/_sage_const_8 )
    j = randrange(rowpos,rowpos+k)
    print('pk real bit',j)
    sys.stdout.flush()
    pk2 = bytearray(pk)
    pk2[j//_sage_const_8 ] = ZZ(pk2[j//_sage_const_8 ]).__xor__(_sage_const_1 <<(j%_sage_const_8 ))
    pk2 = bytes(pk2)
    assert pk2 != pk
    assert encap.encap(pk2,randombytes,params) != False

  if mt < _sage_const_8 *ceil(mt/_sage_const_8 ):
    for j in range(mt,_sage_const_8 *ceil(mt/_sage_const_8 )):
      print('C padding bit',j)
      sys.stdout.flush()
      C2 = bytearray(C)
      C2[j//_sage_const_8 ] |= _sage_const_1 <<(j%_sage_const_8 )
      C2 = bytes(C2)
      assert C2 != C
      assert decap.decap(C2,sk,params) == False

  for loop in range(_sage_const_10 ):
    j = randrange(mt)
    print('C real bit',j)
    sys.stdout.flush()
    C2 = bytearray(C)
    C2[j//_sage_const_8 ] = ZZ(C2[j//_sage_const_8 ]).__xor__(_sage_const_1 <<(j%_sage_const_8 ))
    C2 = bytes(C2)
    assert C2 != C
    assert decap.decap(C2,sk,params) not in (False,sessionkey)

