const FLAG = process.env.FLAG || 'flag{**************************}';
const APP_DOMAIN = process.env.APP_DOMAIN || 'toolbar.guru';

function sleep(ms) {
    return new Promise(res => setTimeout(res, ms));
}

async function visit(url) {
    const browser = await puppeteer.launch({
        headless: true,
        pipe: true,
        args: [
            '--disable-extensions',
            '--disable-gpu',
            '--disable-software-rasterizer',
            '--js-flags=--noexpose_wasm,--jitless',
            '--no-sandbox',
        ],
    });
    console.log('Browser launched');

    try {
        const page = await browser.newPage();

        page.on('console', msg => {
            console.log(msg.type(), msg.text());
        });

        // very secure
        const cookies = [{
            name: 'flag',
            value: FLAG,
            url: `https://${APP_DOMAIN}`,
            secure: true,
            sameSite: 'Strict'
        }];

        await page.setCookie(...cookies);

        await page.goto(url, { waitUntil: [] });

        await sleep(10_000);
        // whew... enough of that.
    } catch (err) {
        console.error('Error visiting page:', err);
    } finally {
        await browser.close();
    }
}
