"use client";

import { useState, useEffect, useMemo, useRef } from "react";
import Toolbar from "./Toolbar";

export default function CalcBar() {
  const [code, setCode] = useState();
  const input = useRef(null);

  const result = useMemo(() => {
    if (!code?.length) return "";
    try {
      return String(eval(code));
    } catch (e) {
      return "";
    }
  }, [code]);

  // init
  useEffect(() => {
    const inputElem = input.current;
    setCode(inputElem.value);
  }, []);

  return (
    <Toolbar logo="/calc.png">
      <input
        placeholder="2+2"
        ref={input}
        value={code}
        onChange={e => setCode(e.target.value)}
      />
      &nbsp;=&nbsp;
      <code>{result}</code>
    </Toolbar>
  );
}
