import Toolbar from "./Toolbar";

export default function MarkdownBar({ md }) {
  return (
    <Toolbar logo="/markdown.png" name="Markdown">
      { md
        ? <div
            suppressHydrationWarning={true}
            dangerouslySetInnerHTML={{ __html: renderMarkdown(md) }}
          />
        : <a href="?md=*test*%20out%20**some**%20markdown%20%60lite%60">Example</a>
      }
    </Toolbar>
  );
}

function renderMarkdown(md) {
  return md.replace(/\*\*([^*]+)\*\*/g, "<strong>$1</strong>")
           .replace(/\*([^*]+)\*/g, "<em>$1</em>")
           .replace(/`([^`]+)`/g, "<code>$1</code>");
}
