import { NextResponse } from "next/server";

export function middleware() {
  const nonce = crypto.randomUUID();
  const csp = `
    default-src 'self';
    script-src 'self' 'nonce-${nonce}' 'strict-dynamic' 'unsafe-eval';
    img-src 'self' data:;
    object-src 'none';
    base-uri 'self';
    form-action 'self';
    frame-ancestors 'none';
    upgrade-insecure-requests;
  `.replace(/\s+/g, " ").trim();

  const response = NextResponse.next();
  response.headers.set("Content-Security-Policy", csp);
 
  return response;
}
